#ifndef _RELATIONINFO_H
#define _RELATIONINFO_H

#include <QtGui>

class RelationInfo
{
	public:
		RelationInfo();
		RelationInfo(QString fkName, QString startTableName, QString endTableName, int state1, int state2);
		virtual ~RelationInfo();

	public:
		QString GetFkName() const;
		QString GetStartTableName() const;
		QString GetEndTableName() const;
		QStringList& GetFkList();
		int GetState1() const;
		int GetState2() const;

	public:
		void AddFkItem(QString item);

	private:
		QString fkName;
		QString startTableName;
		QString endTableName;
		QStringList fkList;
		int state1;
		int state2;
};

inline QString RelationInfo::GetFkName() const
{
	return this->fkName;
}

inline QString RelationInfo::GetStartTableName() const
{
	return this->startTableName;
}

inline QString RelationInfo::GetEndTableName() const
{
	return this->endTableName;
}

inline QStringList& RelationInfo::GetFkList()
{
	return this->fkList;
}

inline int RelationInfo::GetState1() const
{
	return this->state1;
}

inline int RelationInfo::GetState2() const
{
	return this->state2;
}

#endif //_RELATIONINFO_H
